# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from enum import Enum
from .sdapiobject import SDAPIObject
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDTypeModifier(Enum):
    """
    Enum representing the modifier of a type
    """
    """The default modifier (depends on the context or inputs"""
    Auto = 0
    """The type is uniform (will be evaluated once per evaluation of this node)"""
    Uniform = 1
    """The type is varying (will be evaluated multiple times for each evaluation of this node; e.g. once per pixel)"""
    Varying = 2

class SDType(SDAPIObject):
    """
    Class used to store information about value's type
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDType
        """
        super(SDType, self).__init__(APIContext, handle, *args, **kwargs)

    def getId(self) -> str:
        """
        Get the type identifier string

        """
        outId = ctypes.c_char_p()
        _res = self.mAPIContext.SDType_getId(self.mHandle, ctypes.byref(outId))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outId.value.decode('utf-8') # type: ignore

    def getModifier(self) -> SDTypeModifier:
        """
        Get the type modifier (see SDTypeModifier enum)

        """
        outSDTypeModifier = ctypes.c_int()
        _res = self.mAPIContext.SDType_getModifier(self.mHandle, ctypes.byref(outSDTypeModifier))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return SDTypeModifier(outSDTypeModifier.value)

